#import "AppDelegate.h"
#import <React/RCTBundleURLProvider.h>

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
  self.moduleName = @"RNDemoUpdate";
  self.initialProps = @{};
  return [super application:application didFinishLaunchingWithOptions:launchOptions];
}

- (NSURL *)sourceURLForBridge:(RCTBridge *)bridge
{
  return [self getBundleURL];
}

- (NSURL *)getBundleURL
{
#if DEBUG
  return [[RCTBundleURLProvider sharedSettings] jsBundleURLForBundleRoot:@"index"];
#else
  // Đường dẫn bundle tải về
  NSString *bundlePath = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES).firstObject
                            stringByAppendingPathComponent:@"release.bundle"];

  // Kiểm tra nếu file bundle mới tồn tại -> Load bundle mới
  if ([[NSFileManager defaultManager] fileExistsAtPath:bundlePath]) {
    return [NSURL fileURLWithPath:bundlePath];
  }

  // Nếu không có bundle tải về -> Load main.jsbundle
  return [[NSBundle mainBundle] URLForResource:@"main" withExtension:@"jsbundle"];
#endif
}

@end
